/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioPriorityField;
import filenet.sim.api.VWScenarioQueueAssignment;
import filenet.sim.api.VWScenarioRoleAssignment;
import filenet.sim.api.VWScenarioShiftDefinition;
import filenet.sim.api.VWScenarioValidationError;
import filenet.sim.api.VWScenarioXMLHandler;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public final class VWScenarioRoleDefinition
implements Serializable,
Cloneable {
    private VWScenarioDefinition m_scenarioDef = null;
    private List m_roleAssignments = Collections.synchronizedList(new ArrayList());
    private String m_name = null;
    private List m_queues = Collections.synchronizedList(new ArrayList());

    protected VWScenarioRoleDefinition(String name, VWScenarioDefinition scenarioDef) throws VWException {
        this.m_scenarioDef = scenarioDef;
        this.setName(name);
        this.refreshAssignmentCache();
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) throws VWException {
        if (name == null) {
            throw new VWException("sim.api.VWScenarioRoleDefinition.NullRoleNameParameter", "The name parameter can not be null.");
        }
        if (name.equals(this.m_name)) {
            return;
        }
        if (this.m_scenarioDef.hasRole(name)) {
            throw new VWException("sim.api.VWScenarioRoleDefinition.RoleAlreadyExists", "A role with the name {0} has already been created.", name);
        }
        this.m_scenarioDef.updateRole(this.m_name, name);
        this.m_name = name;
        Iterator i = this.m_roleAssignments.iterator();
        while (i.hasNext()) {
            ((VWScenarioRoleAssignment)i.next()).setRoleName(name);
        }
    }

    public VWScenarioQueueAssignment createQueueAssignment(String queueName, int priority) throws VWException {
        if (this.getQueueAssignmentIndex(queueName) != -1) {
            throw new VWException("sim.api.VWScenarioRoleDefinition.QueueAssignmentAlreadyExists", "A queue with the name {0} has already been assigned to this role.", queueName);
        }
        VWScenarioQueueAssignment queueAssignment = new VWScenarioQueueAssignment(queueName, priority, this.m_queues.size() + 1, this);
        this.m_queues.add(queueAssignment);
        return queueAssignment;
    }

    protected VWScenarioQueueAssignment createQueueAssignment(String queueName, int priority, int index) throws VWException {
        int i;
        if (this.getQueueAssignmentIndex(queueName) != -1) {
            throw new VWException("sim.api.VWScenarioRoleDefinition.QueueAssignmentAlreadyExists", "A queue with the name {0} has already been assigned to this role.", queueName);
        }
        VWScenarioQueueAssignment[] queues = this.getQueueAssignments();
        for (i = 0; queues != null && i < queues.length && index > queues[i].getIndex(); ++i) {
        }
        VWScenarioQueueAssignment queueAssignment = new VWScenarioQueueAssignment(queueName, priority, index, this);
        this.m_queues.add(i, queueAssignment);
        return queueAssignment;
    }

    public VWScenarioQueueAssignment[] getQueueAssignments() {
        if (this.m_queues.size() == 0) {
            return null;
        }
        return this.m_queues.toArray(new VWScenarioQueueAssignment[0]);
    }

    public VWScenarioQueueAssignment getQueueAssignment(String queueName) throws VWException {
        if (queueName == null) {
            throw new VWException("sim.api.VWScenarioRoleDefinition.NullQueueNameParameter", "The queueName parameter can not be null.");
        }
        int index = this.getQueueAssignmentIndex(queueName);
        if (index == -1) {
            throw new VWException("sim.api.VWScenarioRoleDefinition.QueueAssignmentNotFound", "Queue {0} has not been assigned to this role.", queueName);
        }
        return (VWScenarioQueueAssignment)this.m_queues.get(index);
    }

    public void deleteQueueAssignment(String queueName) throws VWException {
        if (queueName == null) {
            throw new VWException("sim.api.VWScenarioRoleDefinition.NullQueueNameParameter", "The queueName parameter can not be null.");
        }
        int index = this.getQueueAssignmentIndex(queueName);
        if (index == -1) {
            throw new VWException("sim.api.VWScenarioRoleDefinition.QueueAssignmentNotFound", "Queue {0} has not been assigned to this role.", queueName);
        }
        this.m_queues.remove(index);
    }

    public void reorderQueues(String[] queueNames) throws VWException {
        List<VWScenarioQueueAssignment> queueAssignments = Collections.synchronizedList(new ArrayList());
        if (queueNames == null) {
            throw new VWException("sim.api.VWScenarioRoleDefinition.NullQueueNamesParameter", "Parameter theQueueNames cannot be null.");
        }
        if (queueNames.length != this.m_queues.size()) {
            throw new VWException("sim.api.VWScenarioRoleDefinition.ReorderArrayLength", "Parameter queueNames actual length is {0}, expected length should be {1}.", String.valueOf(queueNames.length), String.valueOf(this.m_queues.size()));
        }
        if (queueNames.length < 2) {
            return;
        }
        for (int i = 0; i < queueNames.length; ++i) {
            for (int j = 0; j < queueNames.length; ++j) {
                if (j == i || queueNames[i] != queueNames[j]) continue;
                throw new VWException("sim.api.VWScenarioRoleDefinition.ReorderArrayDuplicateEntry", "Parameter queueNames, queue name {0} occurs more than once in the array.", queueNames[i]);
            }
            int index = this.getQueueAssignmentIndex(queueNames[i]);
            if (index == -1) {
                throw new VWException("sim.api.VWScenarioRoleDefinition.ReorderArrayInvalidQueue", "Parameter queueNames contains queue name {0}, which is not assigned to this role.", queueNames[i]);
            }
            VWScenarioQueueAssignment qAssignment = (VWScenarioQueueAssignment)this.m_queues.get(index);
            qAssignment.setIndex(i);
            queueAssignments.add(qAssignment);
        }
        this.m_queues = queueAssignments;
    }

    public void toXML(StringBuffer buffer) throws VWException {
        this.toXML(buffer, "");
    }

    protected void toXML(StringBuffer buffer, String baseIndent) throws VWException {
        String LEVEL_1_INDENT = baseIndent + "\t";
        String LEVEL_2_INDENT = LEVEL_1_INDENT + "\t";
        String LEVEL_3_INDENT = LEVEL_2_INDENT + "\t";
        buffer.append(baseIndent + "<Role Name=\"" + VWScenarioXMLHandler.toXMLString(this.getName()) + "\">\n");
        VWScenarioQueueAssignment[] queues = this.getQueueAssignments();
        if (queues != null) {
            buffer.append(LEVEL_1_INDENT + "<QueueAssignments>\n");
            for (int i = 0; i < queues.length; ++i) {
                buffer.append(LEVEL_2_INDENT + "<QueueAssignment ");
                buffer.append("Queue=\"" + VWScenarioXMLHandler.toXMLString(queues[i].getQueueName()) + "\" ");
                int priorityType = queues[i].getPriorityType();
                switch (priorityType) {
                    case 1: {
                        buffer.append("Priority=\"" + VWScenarioXMLHandler.toXMLString("FIELD") + "\" ");
                        break;
                    }
                    case 3: {
                        buffer.append("Priority=\"" + VWScenarioXMLHandler.toXMLString("FIFO") + "\" ");
                        break;
                    }
                    case 0: {
                        buffer.append("Priority=\"" + VWScenarioXMLHandler.toXMLString("NONE") + "\" ");
                        break;
                    }
                    case 2: {
                        buffer.append("Priority=\"" + VWScenarioXMLHandler.toXMLString("OLDEST") + "\" ");
                    }
                }
                buffer.append("Index=\"" + String.valueOf(i + 1) + "\"");
                VWScenarioPriorityField[] fields = queues[i].getPriorityFields();
                if (priorityType != 1 || fields == null) {
                    buffer.append("/>\n");
                    continue;
                }
                buffer.append(">\n");
                for (int j = 0; j < fields.length; ++j) {
                    buffer.append(LEVEL_3_INDENT + "<PriorityField ");
                    buffer.append("Name=\"" + VWScenarioXMLHandler.toXMLString(fields[j].getName()) + "\" ");
                    buffer.append("Type=\"" + VWScenarioPriorityField.typeToString(fields[j].getFieldType()) + "\" ");
                    switch (fields[j].getOrderType()) {
                        case 1: {
                            buffer.append("Order=\"" + VWScenarioXMLHandler.toXMLString("ASCEND") + "\" ");
                            break;
                        }
                        case 2: {
                            buffer.append("Order=\"" + VWScenarioXMLHandler.toXMLString("DESCEND") + "\" ");
                        }
                    }
                    buffer.append("Index=\"" + String.valueOf(j + 1) + "\"");
                    buffer.append("/>\n");
                }
                buffer.append(LEVEL_2_INDENT + "</QueueAssignment>\n");
            }
            buffer.append(LEVEL_1_INDENT + "</QueueAssignments>\n");
        }
        buffer.append(baseIndent + "</Role>\n");
    }

    public void validate(Vector EDefVector, VWSystemConfiguration sysConfig) throws VWException {
        if (this.hasRoleAssignments() && this.m_queues.size() == 0) {
            VWString theMessage = new VWString("sim.api.VWScenarioRoleDefinition.NoQueuesAssigned", "Job does not have any queues assigned.", this.getName());
            VWScenarioValidationError theError = new VWScenarioValidationError(4, 2, this.getName(), null, theMessage.toString());
            EDefVector.addElement(theError);
        }
        Iterator queueAssignments = this.m_queues.iterator();
        while (queueAssignments.hasNext()) {
            ((VWScenarioQueueAssignment)queueAssignments.next()).validate(EDefVector, sysConfig);
        }
    }

    public String toString() {
        return this.getName();
    }

    private int getQueueAssignmentIndex(String queueName) {
        int index = -1;
        int counter = 0;
        ListIterator iterator = this.m_queues.listIterator();
        while (iterator.hasNext()) {
            if (((VWScenarioQueueAssignment)iterator.next()).getQueueName().equals(queueName)) {
                index = counter;
                break;
            }
            ++counter;
        }
        return index;
    }

    protected VWScenarioDefinition getScenario() {
        return this.m_scenarioDef;
    }

    protected boolean hasQueue(String queueName) throws VWException {
        return this.getQueueAssignmentIndex(queueName) != -1;
    }

    protected boolean hasRoleAssignments() {
        return this.m_roleAssignments.size() > 0;
    }

    public VWScenarioRoleAssignment[] getRoleAssignments() {
        if (this.m_roleAssignments.size() == 0) {
            return null;
        }
        return this.m_roleAssignments.toArray(new VWScenarioRoleAssignment[0]);
    }

    protected void addRoleAssignmentToCache(VWScenarioRoleAssignment rAssignment) {
        if (!this.m_roleAssignments.contains(rAssignment)) {
            this.m_roleAssignments.add(rAssignment);
        }
    }

    protected void removeRoleAssignmentFromCache(VWScenarioRoleAssignment rAssignment) {
        this.m_roleAssignments.remove(rAssignment);
    }

    protected Object clone(String roleName) {
        VWScenarioRoleDefinition clone = null;
        try {
            clone = (VWScenarioRoleDefinition)super.clone();
            clone.m_name = roleName;
            clone.m_roleAssignments = Collections.synchronizedList(new ArrayList());
            clone.m_queues = Collections.synchronizedList(new ArrayList());
            Iterator i = this.m_queues.iterator();
            while (i.hasNext()) {
                VWScenarioQueueAssignment q = (VWScenarioQueueAssignment)((VWScenarioQueueAssignment)i.next()).clone();
                q.setRole(clone);
                clone.m_queues.add(q);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    private void refreshAssignmentCache() throws VWException {
        this.m_roleAssignments.clear();
        VWScenarioShiftDefinition[] shifts = this.getScenario().getShifts();
        if (shifts != null) {
            for (int i = 0; i < shifts.length; ++i) {
                if (!shifts[i].hasRole(this.getName())) continue;
                this.addRoleAssignmentToCache(shifts[i].getRoleAssignment(this.getName()));
            }
        }
    }
}

